# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Repository Overview

This is a content/media repository for educational materials related to "LMB01" and "Redação Blindada" (Protected Essay Writing), a Brazilian educational product. The repository contains marketing materials, educational videos, and course content - not source code.

## Repository Structure

```
lmb01/
├── Criativos - Estáticos   Carrosséis/  # Static marketing content and carousels
│   ├── Carrosséis/                      # Image carousels for social media
│   └── [Various marketing materials]
├── Criativos em vídeo/                  # Video content
│   └── Vendas/                          # Sales-related videos
└── Desafio Redação Blindada/            # Educational challenge materials
    └── PDFs/                            # Course PDFs and documents
```

## Content Types

- **Images**: JPG/PNG files for marketing carousels and social media posts
- **Videos**: MP4/MOV educational and sales videos
- **PDFs**: Educational materials and course content
- **Google Docs**: Links to collaborative documents

## Important Notes

- This is NOT a software development project - it's a content repository
- All content is in Portuguese (Brazilian)
- No build, test, or deployment commands are applicable
- Focus on content organization and file management tasks when requested

## Common Tasks

When working in this repository, typical tasks might include:
- Organizing media files by category or date
- Renaming files for better organization
- Creating directory structures for new content
- Analyzing content distribution across folders