# 🚀 Como Executar Todo o Processamento

## Opção 1: Executar TUDO de uma vez (Recomendado)

```bash
# Ativar ambiente virtual
source venv/bin/activate

# Executar processamento completo
python processar_campanha.py lmb01/
```

Este comando vai:
1. ✅ Organizar arquivos por tipo (vídeos, imagens, PDFs, textos)
2. ✅ Transcrever vídeos com Whisper
3. ✅ Extrair texto de imagens (OCR)
4. ✅ Extrair texto de PDFs
5. ✅ Corrigir todos os textos com IA
6. ✅ Criar arquivo markdown compilado
7. ✅ Gerar galeria HTML interativa

**⏱️ Tempo estimado**: 30-120 minutos (depende da quantidade de vídeos)

---

## Opção 2: Executar cada etapa separadamente

### 1️⃣ Organizar arquivos
```bash
source venv/bin/activate
python organizar_campanha.py lmb01/
```

### 2️⃣ Transcrever conteúdo (pode demorar muito!)
```bash
python transcriber.py lmb01/
```

### 3️⃣ Criar markdown compilado
```bash
python create_markdown.py lmb01/
```

### 4️⃣ Gerar galeria HTML
```bash
python generate_gallery.py lmb01/
```

---

## Opção 3: Processar só transcrições (sem limite de tempo)

Se o processamento completo exceder 30 minutos:

```bash
source venv/bin/activate
python processar_transcricoes.py lmb01/
```

Este script não tem limite de tempo e pode ser interrompido/retomado.

---

## 📁 Resultados

Após o processamento, você terá:

```
lmb01/
├── videos/                    # Vídeos organizados
├── imagens/                   # Imagens organizadas
├── textos/                    # Textos e transcrições
├── pdfs/                      # PDFs organizados
├── copy_bank_completo.md      # Todas as transcrições em um arquivo
├── galeria_campanha.html      # Galeria visual interativa
└── campaign_metadata.json     # Metadados do processamento
```

---

## 🔧 Problemas comuns

### "Command not found"
```bash
# Certifique-se de ativar o ambiente virtual primeiro
source venv/bin/activate
```

### "Tesseract não encontrado"
```bash
# macOS
brew install tesseract tesseract-lang

# Ubuntu
sudo apt-get install tesseract-ocr tesseract-ocr-por
```

### Processamento muito lento
- Whisper demora 2-5 minutos por vídeo
- Use `processar_transcricoes.py` para não ter limite de tempo
- Você pode processar em partes (alguns vídeos por vez)

---

## 💡 Dica

Para reprocessar do zero, delete as pastas criadas primeiro:
```bash
rm -rf lmb01/videos lmb01/imagens lmb01/textos lmb01/pdfs lmb01/outros
rm -f lmb01/*.html lmb01/*.md lmb01/*.json
```