# Organizador de Campanha - Milla Borges

Sistema completo para organizar, transcrever e visualizar todos os arquivos de uma campanha de marketing.

## 🚀 Funcionalidades

1. **Organização Automática**: Separa arquivos por tipo (vídeos, imagens, textos, PDFs)
2. **Transcrição de Vídeos**: Usa OpenAI Whisper para transcrever áudio
3. **OCR de Imagens**: Extrai texto de imagens usando Tesseract
4. **Extração de PDFs**: Extrai todo o texto de arquivos PDF
5. **Correção com IA**: Corrige erros de transcrição usando Google Gemini
6. **Galeria Visual**: Gera uma página HTML interativa com todo o conteúdo

## 📋 Pré-requisitos

- Python 3.8+
- Tesseract OCR instalado no sistema
- Conexão com internet (para correção de textos)

### Instalação do Tesseract

**macOS:**
```bash
brew install tesseract tesseract-lang
```

**Ubuntu/Debian:**
```bash
sudo apt-get install tesseract-ocr tesseract-ocr-por
```

**Windows:**
Baixe o instalador em: https://github.com/UB-Mannheim/tesseract/wiki

## 🛠️ Instalação

1. Clone ou baixe os scripts para seu computador

2. Crie e ative o ambiente virtual:
```bash
python3 -m venv venv
source venv/bin/activate  # No Windows: venv\Scripts\activate
```

3. Instale as dependências:
```bash
pip install openai-whisper pillow pytesseract pypdf2 requests beautifulsoup4 jinja2
```

## 💻 Uso

### Opção 1: Script Completo (Recomendado)

Execute tudo de uma vez:
```bash
python processar_campanha.py lmb01/
```

### Opção 2: Scripts Individuais

1. **Organizar arquivos:**
```bash
python organizar_campanha.py lmb01/
```

2. **Transcrever conteúdo:**
```bash
python transcriber.py lmb01/
```

3. **Gerar galeria HTML:**
```bash
python generate_gallery.py lmb01/
```

## 📁 Estrutura Final

Após o processamento, seus arquivos estarão organizados assim:

```
lmb01/
├── videos/          # Todos os vídeos
├── imagens/         # Todas as imagens
├── textos/          # Textos originais + transcrições
├── pdfs/            # Todos os PDFs
├── outros/          # Arquivos não categorizados
├── galeria_campanha.html    # Galeria visual
└── campaign_metadata.json   # Metadados do processamento
```

## 📝 Notas Importantes

- A transcrição de vídeos pode demorar bastante (vários minutos por vídeo)
- O OCR funciona melhor com imagens de boa qualidade e texto claro
- Textos muito longos serão processados em partes
- A API do Gemini tem limite de requisições por minuto

## 🔧 Solução de Problemas

**Erro "Tesseract não encontrado":**
- Instale o Tesseract conforme instruções acima
- Reinicie o terminal após instalação

**Erro de memória com vídeos:**
- O Whisper pode consumir muita memória
- Feche outros programas durante o processamento

**Transcrições vazias:**
- Verifique se o áudio do vídeo está claro
- Imagens podem não conter texto legível

## 📄 Licença

Scripts criados para uso interno da campanha Milla Borges.